uniform sampler2DRect image;
uniform sampler2D vingette;

uniform float bloomFactor;

void main()
{
    
    vec2 texCoords = gl_TexCoord[0].xy;
    vec2 vingetteCoords = gl_TexCoord[1].xy;
    
    vec4 vignetteColor = texture2D(vingette, vingetteCoords) * 0.6 + vec4(0.4);
    
    vec4 baseColor = texture2DRect(image, texCoords) * vignetteColor;
    
    vec4 combined = max((baseColor - vec4(0.2)) * 1.0, vec4(0.0)) + baseColor * bloomFactor;
    combined.a = 1.0;

	gl_FragColor = combined * gl_Color;
}
